implementation module windowOpen;

import StdClass,StdInt,StdBool;
import	windows, quickdraw;
import	commonDef, windowInternal, windowAccess;
from	deltaWindow		import CloseWindows;
from	deltaPicture	import EraseRectangle;

from StdMisc import abort;

CleanWindowRefCon	:== 1;

WindowOpenError :: String String -> * x;
WindowOpenError rule error = Error rule "windowOpen" error;

OpenWindow :: !(DeviceSystem s (IOState s)) !(IOState s) -> IOState s;
OpenWindow (WindowSystem wDefs) ioState
	=	IOStateSetDevice (IOStateSetToolbox tb1 ioState1) (WindowSystemState (windows, NoGlobalCursor));
	where {
		(windows, tb1) = Open_windows (-1) wDefs [] tb;
		(tb, ioState1) = IOStateGetToolbox ioState;
		};
OpenWindow noWindowSystem _
	=	WindowOpenError "OpenWindow" "argument is no WindowSystem";
	
Open_windows :: !WindowPtr ![WindowDef s (IOState s)] ![WindowHandle s] !*Toolbox
	->	(![WindowHandle s],!*Toolbox);
Open_windows behind [wDef : wDefs] wHs tb
| exists							= Open_windows behind wDefs wHs tb1;
| WindowDefHasAttribute wDef goAway	= Open_windows behind wDefs [wH : wHs] tb2;
									= Open_windows behind wDefs [(wDef2, window) : wHs] tb2;
	where {
		(exists, tb1)	= ActivateThisWindow behind wHs id tb;
		(wH,tb2)		= Open_window wDef behind tb1;
		(wDef1, window)	= wH;
		wDef2			= WindowDefSetGoAway f wDef1;
		goAway			= GoAway f;
		id				= WindowDefGetWindowId wDef;
		f				= CloseThisWindow id;
	};
Open_windows _ _ wHs tb = (wHs, tb);

CloseThisWindow :: !WindowId !*s !(IOState *s) -> (!*s, !IOState *s);
CloseThisWindow id s ioState = (s, CloseWindows [id] ioState);

ActivateThisWindow :: !WindowPtr ![WindowHandle s] !WindowId !*Toolbox -> (!Bool, !*Toolbox);
ActivateThisWindow behind [wH : wHs] id tb
| foundIt && behind <> (-1)	= (True, tb);
| foundIt					= (True, SelectWindow wPtr tb);
							= ActivateThisWindow behind wHs id tb;
	where {
		foundIt					= id == WindowDefGetWindowId wDef;
		(wDef, window)			= wH;
		(wPtr, _, _, _, _, _)	= window;
	};
ActivateThisWindow _ _ _ tb = (False, tb);

Open_window :: !(WindowDef s (IOState s)) !WindowPtr !*Toolbox -> (!WindowHandle s, !*Toolbox);
Open_window wDef=:(ScrollWindow id pos title hBarDef vBarDef pictDom minSize initSize f as) behind tb
	= 	((wDef`, window), tb6);
	where {
		(okPos, okHvalues, okVvalues, okMinSize, okInitSize, tb1)
			= ValidateWindow HasControls pos pictDom hValues vValues minSize fMinSize initSize tb;
		(left, top)		= okPos;
		(hVal, hScroll)	= okHvalues;
		(vVal, vScroll)	= okVvalues;
		(initW, initH) = okInitSize;
		(pMin, pMax)	= pictDom;
		(hMin, vMin)	= pMin;
		(hMax, vMax)	= pMax;
		wDef`			= WindowDefSetScrollBarDefs (okHvalues, okVvalues) (
								WindowDefSetMinimumSize okMinSize (
								WindowDefSetUpdate (Update_new f) wDef));
		(wPtr, tb2)		= CreateWindow initRect title True 8 behind True CleanWindowRefCon tb1;
		tb3				= SetWindowZoomState wPtr (hMin, hMax) (vMin, vMax) tb2;
		hBar			= (hControl, hScroll, hMax);
		vBar			= (vControl, vScroll, vMax);
		(hControl, tb4)	= NewScrollBar wPtr hBarBox /*True*/ False hVal hMin hMax` hMax tb3;
		(vControl, tb5)	= NewScrollBar wPtr vBarBox /*True*/ False vVal vMin vMax` vMax tb4;
		hBarBox			= (-1, initH, inc initW, inc (initH + scrollW));
		hMax`			= hMax - initW;
		vBarBox			= (initW, -1, inc (initW + scrollW), inc initH);
		vMax`			= vMax - initH;
		tb6				= SetDefaultFont wPtr tb5;
		updArea			= [((hVal, vVal), (hVal + initW, vVal + initH))];
		window			= (wPtr, hBar, vBar, 0, updArea, (hVal, vVal));
		initRect		= (	left`, 
							top`, 
							left`+initW+scrollW,
							top` +initH+scrollW	);
		scrollW			= ScrollBarWidth;
		hValues			= ScrollBarDefGetValues hBarDef;
		vValues			= ScrollBarDefGetValues vBarDef;
		fMinSize		= WindowDefGetFinalMinimumSize wDef;
		left`			= left+WindowScreenBorder;
		top`			= top +WindowScreenBorder+MenuBarWidth+TitleBarWidth;
	};
Open_window wDef=:(FixedWindow id pos title pictDom f as) behind tb
|	initW == w && initH == h	= ((WindowDefSetUpdate (Update_new f) wDef, window), tb5);
								= Open_window wDef` behind tb1;
	where {
		(okPos, _, _, okMinSize, okInitSize, tb1)
			= ValidateWindow HasNoControls pos pictDom (hMin,1) (vMin,1) fMinSize fMinSize initSize tb;
		(left, top)		= okPos;
		(initW,initH)	= okInitSize;
		(pMin, pMax)	= pictDom;
		(hMin, vMin)	= pMin;
		(hMax, vMax)	= pMax;
		(wPtr, tb2)		= CreateWindow initRect title True 4 behind True CleanWindowRefCon tb1;
		window			= (wPtr, hBar, vBar, 0, updArea, (0,0));
		hBar			= (hControl, 1, hMin);
		vBar			= (vControl, 1, vMin);
		(hControl, tb3)	= NewScrollBar wPtr barBox False hMin hMin hMin hMin tb2;
		(vControl, tb4)	= NewScrollBar wPtr barBox False vMin vMin vMin hMin tb3;
		barBox			= (-49, -17, -1, -1);
		tb5				= SetDefaultFont wPtr tb4;
		updArea			= [((hMin, vMin), (hMin + initW, vMin + initH))];
		initRect		= (	left`, 
							top`, 
							left`+initW,
							top` +initH	);
		initSize		= (w,h);
		fMinSize		= WindowDefGetFinalMinimumSize wDef;
		wDef`			= ScrollWindow id pos title hBarDef vBarDef pictDom okMinSize okInitSize f as;
		hBarDef			= ScrollBar (Thumb hMin) (Scroll 10);
		vBarDef			= ScrollBar (Thumb vMin) (Scroll 10);
		left`			= left+WindowScreenBorder;
		top` 			= top +WindowScreenBorder+MenuBarWidth+TitleBarWidth;
		w				= hMax-hMin;
		h				= vMax-vMin;
	};


SetDefaultFont :: !WindowPtr !*Toolbox -> *Toolbox;
SetDefaultFont ptr tb = InGrafport2 ptr (QTextFont 0) tb;

CreateWindow :: !Rect !WindowTitle !Bool !Int !Int !Bool !Int !*Toolbox -> (!WindowPtr, !*Toolbox);
CreateWindow rect title visible procID behind goAwayFlag refCon tb
	| hasColorQD	= NewCWindow 0 rect title visible procID behind goAwayFlag refCon tb1;
					= NewWindow  0 rect title visible procID behind goAwayFlag refCon tb1;
	where {
		(hasColorQD, tb1) = HasColorQD tb;
	};

Update_new :: !(UpdateFunction *s) !UpdateArea *s	->	(!*s, ![DrawFunction]);
Update_new f updArea s
	=	(s`, [EraseUpdArea updArea : fs]);
	where {
		(s`, fs) = f updArea s;
	};

EraseUpdArea :: !UpdateArea !Picture -> Picture;
EraseUpdArea [rect : rects] pict = EraseUpdArea rects (EraseRectangle rect pict);
EraseUpdArea _ pict = pict;

ValidateWindow ::	!Int !WindowPos !PictureDomain !(!Int,!Int) !(!Int,!Int)
					!MinimumWindowSize !MinimumWindowSize !InitialWindowSize !*Toolbox
	->	(!WindowPos, !(!Int,!Int), !(!Int,!Int), !MinimumWindowSize, !InitialWindowSize, !*Toolbox);
ValidateWindow	type
				pos		=:(left, top)
				domain	=:((hMin,vMin),(hMax,vMax))
				hValues	=:(hVal, hScroll)
				vValues	=:(vVal, vScroll)
				minSize	=:(minW, minH)
				fMinSize=:(fMinW,fMinH)
				initSize=:(initW,initH)
				tb
| hMin >= hMax || vMin >= vMax || dH < fMinW || dV < fMinH
	=	WindowOpenError "ValidateWindow" "WindowDefinition has illegal PictureDomain";
	=	(pos`, hValues`, vValues`, minSize`, initSize`, tb1);
	where {
		pos`					= (Max 0 (Min left sH), Max 0 (Min top sV));
		hValues`				= (hVal`, hScroll`);
		vValues`				= (vVal`, vScroll`);
		modhVal					= Align_thumb hVal hMin hMax` hScroll`;
		modvVal					= Align_thumb vVal vMin vMax` vScroll`;
		minSize`				= (minW``, minH``);
		minW`					= Min minW initW`;
		minH`					= Min minH initH`;
		initSize`				= (initW`, initH`);
		dH`						= Min dH sH;
		dV`						= Min dV sV;
		dH						= hMax - hMin;
		dV						= vMax - vMin;
		hScroll`				= Max 1 (Min hScroll dH);
		vScroll`				= Max 1 (Min vScroll dV);
		sH						= sR - (scrollW + dScrwW);
		sV						= sB - (dScrwW + scrollW + TitleBarWidth + MenuBarWidth);
		scrollW					= If (type == HasControls) ScrollBarWidth 0;
		dScrwW					= 2 * WindowScreenBorder;
		(sL,sT, sR,sB, tb1)		= QScreenRect tb;
		hVal`					= Max hMin (Min modhVal hMax`);
		hMax`					= hMax - initW`;
		vVal`					= Max vMin (Min modvVal vMax`);
		vMax`					= vMax - initH`;
		minW``					= Max minW` fMinW;
		minH``					= Max minH` fMinH;
		initW`					= Min initW dH`;
		initH`					= Min initH dV`;
	};

NewScrollBar :: !WindowPtr !Rect !Bool !Int !Int !Int !Int !*Toolbox -> (!ControlHandle,!*Toolbox);
NewScrollBar window_pointer barBox visible value min max max2 t0
	| max2>32767
		= NewScrollBar window_pointer barBox visible (value>>1) (min>>1) (max>>1) (max2>>1) t0;
		= NewControl window_pointer barBox "" visible value min max 16 0 t0;

